/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.packager;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.packager.ContainerPackager;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePackager
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 640000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static final int TICKS = 10;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 640000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputSlots = new ItemStackHandler(1);
    ItemStackHandler outputSlots = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int burnTimeMax = 0;
    private int burnTime = 0;

    public TilePackager(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.PACKAGER.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TilePackager e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TilePackager e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        --this.burnTime;
        if (this.burnTime <= 0) {
            this.burnTime = 10;
            this.tryDoPackage();
        }
    }

    private void tryDoPackage() {
        if ((Integer)POWERCONF.get() > 0 && this.energy.getEnergyStored() < (Integer)POWERCONF.get()) {
            return;
        }
        this.setLitProperty(true);
        ItemStack stack = this.inputSlots.getStackInSlot(0);
        List recipes = this.f_58857_.m_7465_().m_44013_(RecipeType.f_44107_);
        for (CraftingRecipe rec : recipes) {
            int total;
            if (!TilePackager.isRecipeValid(rec) || (total = this.getCostIfMatched(stack, rec)) <= 0 || !this.outputSlots.insertItem(0, rec.m_8043_().m_41777_(), true).m_41619_()) continue;
            this.inputSlots.extractItem(0, total, false);
            this.outputSlots.insertItem(0, rec.m_8043_().m_41777_(), false);
            this.energy.extractEnergy((Integer)POWERCONF.get(), false);
        }
    }

    public static boolean isRecipeValid(CraftingRecipe recipe) {
        int total = 0;
        int matched = 0;
        Ingredient first = null;
        ItemStack[] firstItems = null;
        for (Ingredient ingr : recipe.m_7527_()) {
            ItemStack[] ingrItemList = ingr.m_43908_();
            if (ingr == Ingredient.f_43901_ || ingrItemList.length == 0) continue;
            ++total;
            if (first == null) {
                first = ingr;
                firstItems = ingrItemList;
                matched = 1;
                continue;
            }
            if (!first.test(ingrItemList[0])) continue;
            ++matched;
        }
        if (first == null || firstItems == null || firstItems.length == 0) {
            return false;
        }
        boolean outIsStorage = recipe.m_8043_().m_204117_(Tags.Items.STORAGE_BLOCKS);
        boolean inIsIngot = firstItems[0].m_204117_(Tags.Items.INGOTS);
        if (!outIsStorage && inIsIngot) {
            return false;
        }
        return !(total <= 0 || total != matched || recipe.m_8043_().m_41741_() <= 1 || total != 4 && total != 9 || recipe.m_8043_().m_41613_() != 1 && recipe.m_8043_().m_41613_() != total);
    }

    private int getCostIfMatched(ItemStack stack, CraftingRecipe recipe) {
        int total = 0;
        int matched = 0;
        for (Ingredient ingr : recipe.m_7527_()) {
            if (ingr == Ingredient.f_43901_) continue;
            ++total;
            if (!ingr.test(stack)) continue;
            ++matched;
        }
        if (!(total != matched || stack.m_41613_() < total || total != 4 && total != 9 || recipe.m_8043_().m_41613_() != 1 && recipe.m_8043_().m_41613_() != total)) {
            return total;
        }
        return -1;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerPackager(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.burnTime;
            }
            case BURNMAX: {
                return this.burnTimeMax;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.burnTime = value;
                break;
            }
            case BURNMAX: {
                this.burnTimeMax = value;
            }
        }
    }

    public int getEnergyMax() {
        return 640000;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        BURNMAX;

    }
}

